/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.mccs;

import com.quantumdata.mccs.MySlider;
import com.quantumdata.mccs.VCPCodes;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;

public abstract class CommonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrollPane;
    protected JPanel pane;
    protected GroupLayout layout;
    protected int numOfCmds;
    protected VCPCodes[] vcpCodes;
    protected boolean panelHasSliders = false;
    protected int numOfSliders;
    protected MySlider[] mySliders;

    public CommonPanel(int n) {
        this.init(n);
    }

    public CommonPanel(int n, int n2) {
        this.init(n);
        this.numOfSliders = n2;
        this.mySliders = new MySlider[this.numOfSliders];
    }

    private void init(int n) {
        this.setLayout(new BorderLayout());
        this.pane = new JPanel();
        this.layout = new GroupLayout(this.pane);
        this.scrollPane = new JScrollPane(this.pane);
        this.pane.setLayout(this.layout);
        this.add(this.scrollPane);
        this.numOfCmds = n;
        this.vcpCodes = new VCPCodes[this.numOfCmds];
    }

    public String getVcpDetails(String string) {
        int n;
        String string2 = "";
        for (n = 0; n < this.numOfCmds; ++n) {
            string2 = this.checkMatchReturnDetails(string, this.vcpCodes[n]);
            if (string2 == "") continue;
            return string2;
        }
        for (n = 0; n < this.numOfSliders; ++n) {
            string2 = this.checkMatchReturnDetails(string, this.mySliders[n].getVcpCode());
            if (string2 == "") continue;
            this.mySliders[n].getThisSlider().setEnabled(true);
            this.mySliders[n].getVcpCode().setSupported(true);
            return string2;
        }
        return string2;
    }

    private String checkMatchReturnDetails(String string, VCPCodes vCPCodes) {
        String string2 = "";
        if (string.startsWith(vCPCodes.getVcpCode())) {
            vCPCodes.setSupported(true);
            string2 = "  " + vCPCodes.getVcpCode() + "h" + " - " + vCPCodes.getCmdName();
            if (string.contains("(")) {
                String string3 = "";
                vCPCodes.unSupportAllDetails();
                for (int i = 3; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == ' ' || c == ')') {
                        string2 = string2 + vCPCodes.getAdditionalDetails(string3);
                        string3 = "";
                        continue;
                    }
                    string3 = string3 + (char)c;
                }
            }
        }
        return string2;
    }

    public void supportAllCmds(boolean bl) {
        int n;
        for (n = 0; n < this.numOfCmds; ++n) {
            this.vcpCodes[n].setSupported(bl);
        }
        for (n = 0; n < this.numOfSliders; ++n) {
            this.mySliders[n].getVcpCode().setSupported(bl);
            this.mySliders[n].getThisSlider().setEnabled(bl);
        }
    }

    public abstract void getAllValues(boolean var1, boolean var2);

    public abstract void refreshPanelContents();
}

